﻿var alarmRows = [];
var colWidth = new Array("180px","60px","70px","70px","70px","330px");
var g_RowFilterCount = 0;
var g_RowActiveCount = 0;

var NUM_COLUMNS = 6;
var TIME = 0;
var SERVERITY = 1;
var MODULE = 2;
var TYPE = 3;
var INSTANCE = 4;
var DETAILS = 5;

var SERVERITY_ALL = 0;
var SERVERITY_URGENCY = 1;
var SERVERITY_MAJOR = 2;
var SERVERITY_MINOR = 3;
var SERVERITY_INFO = 4;

var MODULE_All = 0;
var MODULE_MAINBOARD = 1;
var MODULE_CARD1 = 2;
var MODULE_CARD2 = 3;
var MODULE_CARD3 = 4;
var MODULE_CARD4 = 5;

var TYPE_ALL = 0;
var TYPE_GBE = 1;
var TYPE_RF = 2;
var TYPE_FAN = 3;
var TYPE_POWER = 4;
var TYPE_OTHER = 5;

var LOAD = 1;
var FILTER = 2;
var language;

function DeleteAllAlarms()
{
	var table = document.getElementById("alarmTableID");
	var length = table.rows.length;
	for(var i = 1; i < length; i++)
	{
		table.deleteRow(g_RowFilterCount);
		g_RowFilterCount--; 
	}
}

function FilterAlarms()
{
	var table = document.getElementById("alarmTableID").value;
	var severity = document.getElementById("severity").value;
	var severityObj = document.getElementById("severity");
	var selectedIndex = severityObj.selectedIndex;
	var module = document.getElementById("module").value;
	var type = document.getElementById("type").value;
	var instance = document.getElementById("instance").value;
	var length = alarmRows.length;
	var rowData;
	
	var severityArray = new Array("All", "Urgency", "Major", "Minor", "Info");  //added by chenjin
	
	DeleteAllAlarms();

	for(var i = 0; i < length; i++)
	{
		rowData = alarmRows[i].split("|");
		if((severity != SERVERITY_ALL) && (severityArray[selectedIndex] != rowData[SERVERITY]))
		{
			continue;
		}
		
		if((module == MODULE_All) && (type == TYPE_ALL))
		{
			AddAlarm(rowData, FILTER);
		}
		else if((module == MODULE_All) && (type != TYPE_ALL))
		{
			if(rowData[TYPE] == type)
			{
				AddAlarm(rowData, FILTER);
			}
		}
		else if((module != MODULE_All) && (type == TYPE_ALL))
		{
			if(rowData[MODULE] == module)
			{
				AddAlarm(rowData, FILTER);
			}
		}
		else if((module != MODULE_All) && (type != TYPE_ALL))
		{
			if(instance == "")
			{
				if((rowData[MODULE] == module) && (rowData[TYPE] == type))
				{
					AddAlarm(rowData, FILTER);
				}
			}
			else
			{
				if((rowData[MODULE] == module) && (rowData[TYPE] == type) && (rowData[INSTANCE] == instance))
				{
					AddAlarm(rowData, FILTER);
				}
			}//else
		}// else if
	}//for
	
	document.getElementById("fiterCount").innerHTML = g_RowFilterCount;
}

function AddAlarm(rowData, flag)//flag=1,加载；flag=2，筛选
{
	var table = document.getElementById("alarmTableID");
	if(flag == LOAD)
	{
		rowNum = g_RowActiveCount;
	}
	else
	{
		rowNum = g_RowFilterCount;
	}
	var row = table.insertRow(rowNum + 1);
	
	for(var i = 0; i < NUM_COLUMNS; i++)
	{
		var cell = row.insertCell(i);
		cell.className = rowData[SERVERITY];
		cell.style.width = colWidth[i];
		if(i == SERVERITY)
		{
			if(language == 0)
			{
				cell.innerHTML = rowData[i];
			}
			else
			{
				cell.innerHTML = getAlarmSeveritCh(rowData[i]);
			}
		}
		else if(i == MODULE)
		{
			switch(parseInt(rowData[MODULE]))
			{
				case MODULE_MAINBOARD:
				{
					if(language == 0)
					{
						cell.innerHTML = "Mainboard";
					}
					else
					{
						cell.innerHTML = "主板";
					}
					break;
				}
				case MODULE_CARD1:
				{
					if(language == 0)
					{
						cell.innerHTML = "Card 1";
					}
					else
					{
						cell.innerHTML = "卡 1";
					}
					break;
				}
				case MODULE_CARD2:
				{
					if(language == 0)
					{
						cell.innerHTML = "Card 2";
					}
					else
					{
						cell.innerHTML = "卡 2";
					}
					break;
				}
				case MODULE_CARD3:
				{
					if(language == 0)
					{
						cell.innerHTML = "Card 3";
					}
					else
					{
						cell.innerHTML = "卡 3";
					}
					break;
				}
				case MODULE_CARD4:
				{
					if(language == 0)
					{
						cell.innerHTML = "Card 4";
					}
					else
					{
						cell.innerHTML = "卡 4";
					}
					break;
				}
				default:
				{
					break;
				}
			}
		}
		else if(i == TYPE)
		{
			switch(parseInt(rowData[TYPE]))
			{
				case TYPE_GBE:
				{
					cell.innerHTML = "GbE";
					break;
				}
				case TYPE_RF:
				{
					cell.innerHTML = "RF";
					break;
				}
				case TYPE_FAN:
				{
					if(language == 0)
					{
						cell.innerHTML = "Fan";
					}
					else
					{
						cell.innerHTML = "风扇";
					}
					break;
				}
				case TYPE_POWER:
				{
					if(language == 0)
					{
						cell.innerHTML = "Power";
					}
					else
					{
						cell.innerHTML = "电源";
					}
					break;
				}
				case TYPE_OTHER:
				{
					if(language == 0)
					{
						cell.innerHTML = "Other";
					}
					else
					{
						cell.innerHTML = "其它";
					}
					break;
				}
				default:
				{
					break;
				}
			}
		}
		else
		{
			cell.innerHTML = rowData[i];
		}
	}
	
	if(flag == LOAD)
	{
		g_RowActiveCount++;
	}
	else
	{
		g_RowFilterCount++;
	}
}

function InstChange()
{
	var module = document.getElementById("module").value;
	var type = document.getElementById("type").value;
	
	if((module != MODULE_All) && (type != TYPE_ALL))
	{
		document.getElementById("instance").disabled = false;
	}
	else
	{
		document.getElementById("instance").disabled = true;
	}
}

var row_index;
var init_row = true;
function GetCureentAlarms()
{
	var rowData;
	var Response;
	var xmlhttp = getHTTPObject();
	
	if(init_row)
	{
		row_index = 0;
	}

	var getParam = "type=22&cmd=1&language=" + language + "&row_index=" + row_index;

	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParam.length);

	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				Response = gb2utf8(xmlhttp.responseBody);
				var index = Response.indexOf("</html>");
				var bias = Response.length - index;
				Response = Response.slice(7, - bias);
			}
			else
			{
				Response = xmlhttp.responseText.slice(7, -8);
			}
			var alarmResponse = Response.split("&");
			var alarmNum = alarmResponse.length;
			for(var i = 0; i < alarmNum; i++)
			{
				if(alarmResponse[i] == "end")
				{
					continue;
				}
				if(alarmResponse[i].indexOf("row_index") != -1)
				{
					continue;
				}
				alarmRows.push(alarmResponse[i]);
				rowData = alarmResponse[i].split("|");
				AddAlarm(rowData, LOAD);
			}
			
			init_row = false;
			
			if(alarmResponse[alarmNum - 1].indexOf("row_index") != -1)
			{
				var cur_row_string = alarmResponse[alarmNum - 1].split(",");
				row_index = cur_row_string[1];
			}

			if(alarmResponse[alarmNum - 1] == "end")
			{
				init_row = true;
				document.getElementById("fiterCount").innerHTML = g_RowActiveCount;
				g_RowFilterCount = g_RowActiveCount;
				document.getElementById("ActiveCount").innerHTML = g_RowActiveCount;
				return true;
			}
			setTimeout("GetCureentAlarms()", 5);
		}//if
	}
	xmlhttp.send(getParam);
}


window.onload = function()
{
	language = document.getElementById("language").value;
	GetCureentAlarms();
	var devAttr = top.deviceAttr;
	
	if(devAttr == 1)
	{
		//C518
		document.getElementById("module").disabled = true;
	}
}


